/*
 * Decompiled with CFR 0.152.
 */
package com.thane.thaneupdater;

import com.thane.thaneupdater.Common;
import com.thane.thaneupdater.FileDownload;
import com.thane.thaneupdater.ThaneConfigMgr;
import com.thane.thaneupdater.ThaneFileMgr;
import com.thane.thaneupdater.ThaneModMgr;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class ThaneUpdater {
    private static final float THANE_VERSION = 3.0f;
    private static final String OUTPUT_DIRECTORY = "/tmp";
    private static final String TAR_GZIP_SUFFIX = ".7z";
    private static final String MULTIPLE_RESOURCES = "/example-multiple-resources";
    private static final String RECURSIVE_DIRECTORY = "/example-recursive-directory";
    private static final String MULTIPLE_RESOURCES_PATH = "/tmp/example-multiple-resources.7z";
    private static final String RECURSIVE_DIRECTORY_PATH = "/tmp/example-recursive-directory.7z";
    private static final String UPDATERCFG_DIRECTORY = "./";
    private static final String UPDATERCFG_FILENAMELOCAL = "thaneconfig.json";
    private static final String UPDATERCFG_FILENAMEREMOTE = "thaneconfigremote.json";
    private static final String UPDATERMOD_DIRECTORY = "./";
    private static final String UPDATERMOD_FILENAMELOCAL = "thanemodlocal.json";
    private static final String UPDATERMOD_FILENAMEREMOTE = "thanemodremote1.json";
    private static final String UPDATERCMD_DIRECTORY = "./";
    private static final String UPDATERCMD_FILENAME = "thanefile.json";
    private static final String MOD_DIRECTORY = "./";
    private static final String MOD_FILENAME = "modpak1.7z";

    public static void main(String ... args) throws IOException {
        ThaneConfigMgr thaneConfigMgr = new ThaneConfigMgr(3.0f, "./", UPDATERCFG_FILENAMELOCAL);
        Common.ShowMessage("Welcome to Thane.  Click OK to synchronize your files with the latest.");
        if (thaneConfigMgr.readConfig()) {
            if (thaneConfigMgr.updateVersion()) {
                if (thaneConfigMgr.verifyVersion(UPDATERCFG_FILENAMEREMOTE)) {
                    String URL2 = thaneConfigMgr.getURL();
                    FileDownload fileDownload = new FileDownload();
                    if (FileDownload.downloadWithApacheCommons(URL2 + UPDATERCMD_FILENAME, "./thanefile.json")) {
                        ThaneFileMgr thaneFileMgr = new ThaneFileMgr(UPDATERCMD_FILENAME);
                        final ThaneModMgr thaneModMgr = new ThaneModMgr("./", UPDATERMOD_FILENAMELOCAL, UPDATERMOD_FILENAMEREMOTE);
                        if (thaneFileMgr.process(thaneModMgr.preProcess(URL2))) {
                            Common.ShowMessage("Preprocessing complete.  Click Start to download and apply the latest modpaks.");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ThaneModMgr.createAndShowGUI(thaneModMgr);
                                }
                            });
                            while (thaneModMgr.getProgress() < thaneModMgr.getMaxProgress()) {
                                int iTest = thaneModMgr.getProgress();
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            File file = new File(UPDATERCMD_FILENAME);
                            file.delete();
                            File file1 = new File(UPDATERMOD_FILENAMEREMOTE);
                            file1.delete();
                            Common.ShowMessage("Update complete!  You are all set to connect.");
                        } else {
                            Common.ShowMessage("Something went wrong processing thanelist, run in a command prompt for more information");
                        }
                    } else {
                        Common.ShowMessage("Unable to find files in remote data store");
                    }
                } else {
                    Common.ShowMessage("Thaneupdater needs updating!");
                }
            } else {
                Common.ShowMessage("Error: Thaneupdater could not write to its version file.");
            }
        } else {
            Common.ShowMessage("Thaneconfig.json not found.");
        }
    }
}

