/*
 * Decompiled with CFR 0.152.
 */
package com.thane.thaneupdater;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thane.thaneupdater.Common;
import com.thane.thaneupdater.FileDownload;
import com.thane.thaneupdater.SevenZ;
import com.thane.thaneupdater.ThaneMod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ThaneModMgr
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private List<ThaneMod> m_thaneModListLocal;
    private List<ThaneMod> m_thaneModListRemote;
    private final String m_localDirectory;
    private final String m_filenameLocal;
    private final String m_filenameRemote;
    private Set m_modPaksToAppySet;
    private String m_URL;
    private static JFrame s_frame;
    private JProgressBar m_progressBar;
    private JButton m_startButton = new JButton("Start");
    private TaskProcessModPaks m_taskProcessModPaks;

    public static void createAndShowGUI(ThaneModMgr modMgr) {
        s_frame = new JFrame();
        s_frame.setDefaultCloseOperation(3);
        s_frame.setLocationRelativeTo(null);
        modMgr.setOpaque(true);
        s_frame.setContentPane(modMgr);
        s_frame.pack();
        s_frame.setVisible(true);
    }

    public ThaneModMgr(String modDirectory, String filenameLocal, String filenameRemote) {
        super(new BorderLayout());
        this.m_startButton.setActionCommand("start");
        this.m_startButton.addActionListener(this);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        panel.add(this.m_startButton);
        panel.add(this.m_progressBar);
        this.add((Component)panel, "First");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.m_localDirectory = modDirectory;
        this.m_filenameLocal = filenameLocal;
        this.m_filenameRemote = filenameRemote;
        this.m_modPaksToAppySet = new HashSet();
    }

    public int getMaxProgress() {
        return this.m_progressBar.getMaximum();
    }

    public Set getModPakSet() {
        return this.m_modPaksToAppySet;
    }

    public int getProgress() {
        return this.m_progressBar.getValue();
    }

    public Set preProcess(String URL2) {
        try {
            this.m_URL = URL2;
            FileDownload fileDownload = new FileDownload();
            ObjectMapper mapper = new ObjectMapper();
            if (FileDownload.downloadWithApacheCommons(this.m_URL + this.m_filenameRemote, this.m_localDirectory + this.m_filenameRemote)) {
                this.m_thaneModListRemote = Arrays.asList((Object[])mapper.readValue(Paths.get(this.m_localDirectory + this.m_filenameRemote, new String[0]).toFile(), ThaneMod[].class));
                File file = new File(this.m_localDirectory + this.m_filenameLocal);
                if (file.exists()) {
                    this.m_thaneModListLocal = Arrays.asList((Object[])mapper.readValue(Paths.get(this.m_localDirectory + this.m_filenameLocal, new String[0]).toFile(), ThaneMod[].class));
                    for (ThaneMod thaneModRemote : this.m_thaneModListRemote) {
                        boolean bMatchFound = false;
                        for (ThaneMod thaneModLocal : this.m_thaneModListLocal) {
                            bMatchFound |= thaneModLocal.getModPakNum() == thaneModRemote.getModPakNum();
                        }
                        if (bMatchFound) continue;
                        this.m_modPaksToAppySet.add(thaneModRemote.getModPakNum());
                    }
                } else {
                    for (ThaneMod thaneModRemote : this.m_thaneModListRemote) {
                        this.m_modPaksToAppySet.add(thaneModRemote.getModPakNum());
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.m_modPaksToAppySet;
    }

    public boolean process(String URL2) {
        boolean bRet = false;
        try {
            boolean iProgress = false;
            FileDownload fileDownload = new FileDownload();
            for (ThaneMod thaneModRemote : this.m_thaneModListRemote) {
                if (!this.m_modPaksToAppySet.contains(thaneModRemote.getModPakNum())) continue;
                if (FileDownload.downloadWithApacheCommons(URL2 + thaneModRemote.getName(), this.m_localDirectory + thaneModRemote.getName())) {
                    if (!thaneModRemote.getName().contains(".7z")) continue;
                    SevenZ.decompress(this.m_localDirectory + thaneModRemote.getName(), new File(this.m_localDirectory));
                    File file = new File(thaneModRemote.getName());
                    file.delete();
                    continue;
                }
                String sMsg = "Something went wrong applying modpak " + thaneModRemote.getName() + ", run in a command prompt for more information";
                Common.ShowMessage(sMsg);
                throw new Exception(sMsg);
            }
            bRet = this.updateModfileLocal();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    public boolean updateModfileLocal() {
        boolean bRet = false;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(Paths.get(this.m_localDirectory + this.m_filenameLocal, new String[0]).toFile(), this.m_thaneModListRemote);
            bRet = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.m_startButton.setEnabled(false);
        this.m_taskProcessModPaks = new TaskProcessModPaks(this);
        this.m_taskProcessModPaks.addPropertyChangeListener(this);
        this.m_taskProcessModPaks.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if ("progress" == arg0.getPropertyName()) {
            int iProgress = (Integer)arg0.getNewValue();
            this.m_progressBar.setValue(iProgress);
        }
    }

    class TaskProcessModPaks
    extends SwingWorker<Void, Void> {
        private final ThaneModMgr m_modMgr;

        TaskProcessModPaks(ThaneModMgr modMgr) {
            this.m_modMgr = modMgr;
        }

        @Override
        public Void doInBackground() {
            boolean bRet = false;
            try {
                int iProgress = 0;
                FileDownload fileDownload = new FileDownload();
                int iTest = this.m_modMgr.m_thaneModListRemote.size();
                this.m_modMgr.m_progressBar.setMaximum(this.m_modMgr.m_thaneModListRemote.size() * 2);
                this.setProgress(0);
                for (ThaneMod thaneModRemote : this.m_modMgr.m_thaneModListRemote) {
                    if (this.m_modMgr.m_modPaksToAppySet.contains(thaneModRemote.getModPakNum())) {
                        this.m_modMgr.m_progressBar.setString("Fetching modpak" + thaneModRemote.getModPakNum());
                        if (FileDownload.downloadWithApacheCommons(ThaneModMgr.this.m_URL + thaneModRemote.getName(), this.m_modMgr.m_localDirectory + thaneModRemote.getName())) {
                            this.setProgress(++iProgress);
                            this.m_modMgr.m_progressBar.setString("Applying modpak" + thaneModRemote.getModPakNum());
                            if (thaneModRemote.getName().contains(".7z")) {
                                SevenZ.decompress(this.m_modMgr.m_localDirectory + thaneModRemote.getName(), new File(this.m_modMgr.m_localDirectory));
                                File file = new File(thaneModRemote.getName());
                                file.delete();
                            }
                            this.setProgress(++iProgress);
                            continue;
                        }
                        String sMsg = "Something went wrong applying modpak " + thaneModRemote.getName() + ", run in a command prompt for more information";
                        Common.ShowMessage(sMsg);
                        throw new Exception(sMsg);
                    }
                    this.setProgress(iProgress += 2);
                }
                bRet = ThaneModMgr.this.updateModfileLocal();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                s_frame.dispose();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }

        @Override
        public void done() {
        }
    }
}

