/*
 * Decompiled with CFR 0.152.
 */
package com.thane.thaneupdater;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thane.thaneupdater.ThaneFile;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class ThaneFileMgr {
    private List<ThaneFile> m_thaneFileList;
    private final String m_localFilenameFullPath;

    public ThaneFileMgr(String localFilenameFullPath) {
        this.m_localFilenameFullPath = localFilenameFullPath;
    }

    public boolean process(Set m_modPaksToAppySet) {
        boolean bRet = false;
        try {
            ObjectMapper mapper = new ObjectMapper();
            this.m_thaneFileList = Arrays.asList((Object[])mapper.readValue(Paths.get(this.m_localFilenameFullPath, new String[0]).toFile(), ThaneFile[].class));
            for (ThaneFile thaneFile : this.m_thaneFileList) {
                File fullPath = new File(thaneFile.getName());
                if (!m_modPaksToAppySet.stream().anyMatch(o -> o.equals(thaneFile.getModPakNum()))) continue;
                if (thaneFile.getIsDirectory()) {
                    FileUtils.deleteDirectory(fullPath);
                    continue;
                }
                fullPath.delete();
            }
            bRet = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }
}

