/*
 * Decompiled with CFR 0.152.
 */
package com.thane.thaneupdater;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thane.thaneupdater.Common;
import com.thane.thaneupdater.FileDownload;
import com.thane.thaneupdater.ThaneConfig;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;

public class ThaneConfigMgr {
    private List<ThaneConfig> m_thaneConfigList;
    private final String m_localFilenameFullPath;
    private final String m_localPath;
    private final float m_thaneVersion;
    private String m_url;
    private ThaneConfig m_thaneConfig;

    public ThaneConfigMgr(float thaneVersion, String path, String localFilename) {
        this.m_thaneVersion = thaneVersion;
        this.m_localPath = path;
        this.m_localFilenameFullPath = path + localFilename;
    }

    public String getURL() {
        return this.m_thaneConfig.getURL();
    }

    public boolean readConfig() {
        boolean bRet = false;
        try {
            ObjectMapper mapper = new ObjectMapper();
            File file = new File(this.m_localFilenameFullPath);
            if (file.exists()) {
                this.m_thaneConfig = mapper.readValue(Paths.get(this.m_localFilenameFullPath, new String[0]).toFile(), ThaneConfig.class);
                bRet = true;
            } else {
                Common.ShowMessage("Unable to find thaneconfig.json.  Is it in the same directory as thaneupdater?");
                bRet = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    public boolean updateVersion() {
        boolean bRet = false;
        try {
            ObjectMapper mapper = new ObjectMapper();
            this.m_thaneConfig.setThaneVersion(this.m_thaneVersion);
            mapper.writeValue(Paths.get(this.m_localFilenameFullPath, new String[0]).toFile(), (Object)this.m_thaneConfig);
            bRet = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    public boolean verifyVersion(String remoteFilename) {
        boolean bRet = true;
        try {
            ObjectMapper mapper = new ObjectMapper();
            FileDownload fileDownload = new FileDownload();
            File file = new File(this.m_localFilenameFullPath);
            if (file.exists()) {
                ThaneConfig thaneConfigLocal = mapper.readValue(Paths.get(this.m_localFilenameFullPath, new String[0]).toFile(), ThaneConfig.class);
                if (FileDownload.downloadWithApacheCommons(this.getURL() + remoteFilename, this.m_localPath + remoteFilename)) {
                    ThaneConfig thaneConfigRemote = mapper.readValue(Paths.get(this.m_localPath + remoteFilename, new String[0]).toFile(), ThaneConfig.class);
                    if ((int)thaneConfigLocal.getThaneVersion() != (int)thaneConfigRemote.getThaneVersion()) {
                        Common.ShowMessage("Thane Updater needs an update!  Grab the latest and try again.");
                        bRet = false;
                    } else {
                        bRet = true;
                    }
                } else {
                    Common.ShowMessage("Error connecting to remote server for validation, please try again.");
                    bRet = false;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }
}

