/*
 * Decompiled with CFR 0.152.
 */
package com.thane.thaneupdater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

public class SevenZ {
    private SevenZ() {
    }

    public static void compress(String archivePath, File ... files) throws IOException {
        File archiveFile = new File(archivePath);
        try (SevenZOutputFile out = new SevenZOutputFile(archiveFile);){
            for (File file : files) {
                if (file == null || !file.exists()) continue;
                SevenZ.addToArchiveCompression(out, file, "");
            }
        }
    }

    public static void decompress(String archivePath, File destination) throws IOException {
        if (!destination.exists() && !destination.mkdirs()) {
            throw new IOException("Could not create destination directory: " + destination);
        }
        File archiveFile = new File(archivePath);
        try (SevenZFile sevenZFile = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = sevenZFile.getNextEntry()) != null) {
                String entryName = entry.getName();
                File outFile = new File(destination, entryName);
                String destPath = destination.getCanonicalPath();
                String outPath = outFile.getCanonicalPath();
                if (!outPath.startsWith(destPath + File.separator)) {
                    throw new IOException("Blocked entry outside destination dir: " + entryName);
                }
                if (entry.isDirectory()) {
                    if (outFile.isDirectory() || outFile.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + outFile);
                }
                File parent = outFile.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Could not create directory: " + parent);
                }
                FileOutputStream out = new FileOutputStream(outFile);
                Throwable throwable = null;
                try {
                    int n;
                    while ((n = sevenZFile.read(buffer, 0, buffer.length)) > 0) {
                        out.write(buffer, 0, n);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
    }

    private static void addToArchiveCompression(SevenZOutputFile out, File file, String dir) throws IOException {
        String name;
        String string = name = dir.isEmpty() ? file.getName() : dir + "/" + file.getName();
        if (file.isFile()) {
            SevenZArchiveEntry entry = out.createArchiveEntry(file, name);
            out.putArchiveEntry(entry);
            try (FileInputStream in = new FileInputStream(file);){
                int count;
                byte[] buffer = new byte[8192];
                while ((count = in.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
            }
            out.closeArchiveEntry();
        } else if (file.isDirectory()) {
            SevenZArchiveEntry dirEntry = out.createArchiveEntry(file, name + "/");
            out.putArchiveEntry(dirEntry);
            out.closeArchiveEntry();
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    SevenZ.addToArchiveCompression(out, child, name);
                }
            }
        } else {
            System.out.println("Skipping unsupported file: " + file);
        }
    }
}

